	% DIGFI EXAMPLE 11.4
	clear all
	clc
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	wcT = 0.25*pi; wsT = 0.6*pi; Amax = 0.2829; Amin = 30;
	Rs = 1; RL = 1;
	Omegac = tan(wcT/2); Omegas = tan(wsT/2);
	Omegas/Omegac;
	N = CH_ORDER_S(Omegac, Omegas, Amax, Amin);
	N = 3;
	[G, Z, R_ZEROS, P, Wsnew] = CH_I_POLES_S(Omegac, Omegas, Amax, Amin, N);
	Ladder = 1;T = 1;
	[L, C, KI] = CH_I_LADDER(1, Omegas/Omegac, Amax, Amin, N,  Rs, RL, Ladder);
	L = L*Rs/Omegac; C = C/(Rs*Omegac);
	Rs
	RL
	R1 = L(1)
	R2 = 1/C(2);
	R3 = L(3);
	
	W = linspace(0, Omegas, 1000);
	KI(4) = 6; KI(5) = 6;
	Z0(4) = RL; Z0(5) = RL;
	H = LADDER_2_H(N, Z0, L, C, Rs, RL, KI, W, T);
	Att = MAG_2_ATT(H*2);
	
	figure(1)
	PLOT_ATT_S(W, Att)
	zoom on
	%	First step with Kuroda transformation
	R4 = R3 + RL
	Z0(3) = R4; KI(3) = 6; Z0(4) = RL; 
	R5 = RL + RL^2/R3
	C(4) = 1/R5; KI(4) = 9;   
	
	%	Second step with Kuroda transformations
	R6 = R2*R4/(R2+R4)
	R7 = R4^2/(R2+R4)
	R8 = R5*RL/(R5+RL)
	R9 = RL^2/(R5+RL)
	%
	1
	a11 = 2*Rs/(Rs+R1+R6)
	a12=2*R1/(Rs+R1+R6)
	a13=2*R8/(Rs+R1+R6)
	2
	a21 = 2*R6/(R6+R7+R8)
	a22=2*R7/(R6+R7+R8)
	a23=2*R8/(R6+R7+R8)
	3
	a31 = 2*R8/(RL+R9+R8)
	a32=2*R9/(RL+R9+R8)
	a33=2*RL/(RL+R9+R8)
	
	% Check the design, by computing the resulting chain matrix
	L(3) = R7; L(5) = R9; K(1) = 2; K(3) = 2;  K(5) = 2;
	Z0(2) = R6; Z0(4) = R8; K(2) = 6; K(4) = 6; T = 1;	
	H = LADDER_2_H(N, Z0, L, C, Rs, RL, KI, W, T);
	
	figure(2)
	Att = MAG_2_ATT(H*2);
	PLOT_ATT_S(W, Att)
	zoom on
	figure(3)
	Phase = angle(H);
	%	PLOT_PHASE_S(W, Phase);
	for n = 1:length(W)-1
		Tg(n) = -(Phase(n+1)-Phase(n))*1000/Omegas;
	end
	for n=1:length(W)-2
		if abs(Tg(n+1) - Tg(n)) > 10
			Tg(n+1) = Tg(n);
		end
	end
	Tg(length(W)) = Tg(length(W)-1);
	%	subplot('position', [0.08 0.4 0.90 0.5]);
	
	subplot('position', [0.08 0.4 0.90 0.5]);
	plot(W, Tg, 'linewidth', lw)   	
	axis([0 max(W) 0 ceil(max(Tg)*1.2)]); %  This may be changed to get a neater plot
	hold on;
	set(gca,'FontName', fn,'FontSize', fs);
	xlabel('{\it\Omega}  ','FontName', fn,'FontSize',fs);
	ylabel('{\it\tau_g}({\it\Omega}) ','FontName', fn,'FontSize',fs);	
	grid on
	hold on
	Taug = PZ_2_TG_S(G, Z, P, W);
	plot(W, Taug,'linewidth', 2);
	text(0.65, 4,'Chebyshev I','FontName',fn,'FontSize',fs);	
	text(0.05, 8.5,'Inserted unit elements','FontName',fn,'FontSize',fs);
	
	figure(4)
	Z=[-1 -1 -1 0 0];
	P=[0.1318264*i -0.1318264*i 0.5090041+0.5818714*i 0.5090041-0.5818714*i 0.5379410];
	PLOT_PZ_Z(Z, P)
	
